// Generated by CoffeeScript 1.10.0
(function() {
  var Marks, root;

  Marks = {
    getLocationKey: function(markName) {
      return "vimiumGlobalMark|" + markName;
    },
    getBaseUrl: function(url) {
      return url.split("#")[0];
    },
    create: function(req, sender) {
      return chrome.storage.local.get("vimiumSecret", (function(_this) {
        return function(items) {
          var markInfo;
          markInfo = {
            vimiumSecret: items.vimiumSecret,
            markName: req.markName,
            url: _this.getBaseUrl(sender.tab.url),
            tabId: sender.tab.id,
            scrollX: req.scrollX,
            scrollY: req.scrollY
          };
          if ((markInfo.scrollX != null) && (markInfo.scrollY != null)) {
            return _this.saveMark(markInfo);
          } else {
            return chrome.tabs.sendMessage(sender.tab.id, {
              name: "getScrollPosition",
              frameId: 0
            }, function(response) {
              return _this.saveMark(extend(markInfo, {
                scrollX: response.scrollX,
                scrollY: response.scrollY
              }));
            });
          }
        };
      })(this));
    },
    saveMark: function(markInfo) {
      var item;
      item = {};
      item[this.getLocationKey(markInfo.markName)] = markInfo;
      return chrome.storage.sync.set(item);
    },
    goto: function(req, sender) {
      return chrome.storage.local.get("vimiumSecret", (function(_this) {
        return function(items) {
          var key, vimiumSecret;
          vimiumSecret = items.vimiumSecret;
          key = _this.getLocationKey(req.markName);
          return chrome.storage.sync.get(key, function(items) {
            var markInfo;
            markInfo = items[key];
            if (!markInfo) {
              return chrome.tabs.sendMessage(sender.tab.id, {
                name: "showHUDforDuration",
                text: "全局标记未设置: '" + req.markName + "'.",
                duration: 1000
              });
            } else if (markInfo.vimiumSecret !== vimiumSecret) {
              return _this.focusOrLaunch(markInfo);
            } else {
              return chrome.tabs.get(markInfo.tabId, function(tab) {
                if (!chrome.runtime.lastError && (tab != null ? tab.url : void 0) && markInfo.url === _this.getBaseUrl(tab.url)) {
                  return _this.gotoPositionInTab(markInfo);
                } else {
                  return _this.focusOrLaunch(markInfo);
                }
              });
            }
          });
        };
      })(this));
    },
    gotoPositionInTab: function(arg) {
      var markName, scrollX, scrollY, tabId;
      tabId = arg.tabId, scrollX = arg.scrollX, scrollY = arg.scrollY, markName = arg.markName;
      return chrome.tabs.update(tabId, {
        selected: true
      }, function() {
        return chrome.tabs.sendMessage(tabId, {
          name: "setScrollPosition",
          scrollX: scrollX,
          scrollY: scrollY
        }, function() {
          return chrome.tabs.sendMessage(tabId, {
            name: "showHUDforDuration",
            text: "跳转到全局标记 '" + markName + "'.",
            duration: 1000
          });
        });
      });
    },
    focusOrLaunch: function(markInfo) {
      return chrome.tabs.query({
        url: markInfo.url
      }, (function(_this) {
        return function(tabs) {
          if (0 < tabs.length) {
            return _this.pickTabInWindow(tabs, function(tab) {
              return _this.gotoPositionInTab(extend(markInfo, {
                tabId: tab.id
              }));
            });
          } else {
            return TabOperations.openUrlInNewTab({
              url: _this.getBaseUrl(markInfo.url)
            }, function(tab) {
              return tabLoadedHandlers[tab.id] = function() {
                return _this.gotoPositionInTab(extend(markInfo, {
                  tabId: tab.id
                }));
              };
            });
          }
        };
      })(this));
    },
    pickTabInWindow: function(tabs, continuation) {
      return chrome.windows.getCurrent(function(arg) {
        var id, ref, tabsInWindow;
        id = arg.id;
        tabsInWindow = tabs.filter(function(tab) {
          return tab.windowId === id;
        });
        return continuation((ref = tabsInWindow[0]) != null ? ref : tabs[0]);
      });
    }
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Marks = Marks;

}).call(this);
